#!/bin/bash
MODEL_PATH=$1
set -e # exit on error
pred_file=${MODEL_PATH}/unk_vqa_public_val_k_minus_llava_remove_ans_type2/answers/merge.jsonl

python inf_qwen_vl.py eval \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/UNK-VQA/val_k_minus_llava_remove_ans_type2.llava_eval.jsonl  \
        --image-folder <DATA_FOLDER>/UNK-VQA \
        --answer-file ${pred_file}
        
output_file=${MODEL_PATH}/unk_vqa_public_val_k_minus_llava_remove_ans_type2/pred_probs_only_yes_or_no/merge.jsonl
python inf_qwen_vl.py get_pred_prob_only_yes_or_no \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/UNK-VQA/val_k_minus_llava_remove_ans_type2.llava_eval.jsonl  \
        --image-folder <DATA_FOLDER>/UNK-VQA \
        --pred_file ${pred_file} \
        --answer-file ${output_file} 
